#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <pthread.h>
#include <signal.h>

#include <pgpUtilities.h>
#include <pgpThreads.h>
#include <pgpRPCMsg.h>
#include "pgpPFLErrors.h"

extern int debug;
PGPMutex_t sRPCMutex;
void * conn_thread(void *);
#define PGPSOCKNAME "/var/.pgpsdksock"

uid_t	rootUserID;
gid_t	rootGrpID;

void sig_handler(int sig)
{
    PGPMutexDestroy(&sRPCMutex);

    PGPsdkCleanup();
}

run_pgpsdkd()
{
	int sd, n, hiwat_fd = 50;
	struct sockaddr_un addr;
	fd_set readfds;
	pthread_attr_t	attr;
	pthread_t	thread;

	pthread_attr_init(&attr);
	pthread_attr_setdetachstate(&attr, PTHREAD_CREATE_DETACHED);

	rootUserID = geteuid();
	rootGrpID = getegid();

	/* Don't barf on SIGPIPE */
	signal(SIGPIPE,SIG_IGN);
    signal(SIGTERM,sig_handler);

	PGPMutexCreate(&sRPCMutex, NULL);

	pgpRPCCreateBEContext(); /* does PGPsdkInit() too..  */

	unlink(PGPSOCKNAME);

	sd = socket(PF_UNIX, SOCK_STREAM, 0);
	if (sd == -1) {
		perror("socket(AF_UNIX)");
		exit(1);
	}

	bzero(&addr, sizeof(addr));
	addr.sun_family = AF_UNIX;
	strcpy(addr.sun_path, PGPSOCKNAME);

	n = bind(sd, (struct sockaddr *)&addr, sizeof(addr));
	if (n == -1) {
		perror("bind");
		exit(1);
	}
	chmod(PGPSOCKNAME, 0766);

	listen(sd, 5);

	FD_ZERO(&readfds);
	FD_SET(sd, &readfds);

	if (debug)
		printf("WAITING FOR CONNECTIONS: fd=%d\n", sd);

	for(;;) {
		fd_set tmp_readfds = readfds;
		int i, nfds;

		nfds = select(hiwat_fd, &tmp_readfds, NULL, NULL, NULL);
		if (nfds == -1) {
			perror("select");
			exit(1);
		}

		/*
		 * CHECK FOR NEW CONNECTION
		 */
		if (FD_ISSET(sd, &tmp_readfds)) {
			struct sockaddr_un fromaddr;
			int fromlen, new_sd, rv;

			--nfds;
			fromlen = sizeof(fromaddr);
			new_sd = accept(sd, (struct sockaddr *)&fromaddr, &fromlen);
			if (new_sd == -1) {
				perror("accept()");
				exit(1);
			}
			rv = pthread_create(&thread, &attr, conn_thread, (void *)new_sd);
			if(rv)
			{
				perror("pthread_create()");
				exit(1);
			}
		}
	}
	PGPMutexDestroy(&sRPCMutex);
    PGPsdkCleanup();
}

void *
conn_thread(void *arg)
{
	int			sd = (int)arg, n;
	char			*buf = NULL;
	char			*next = NULL;
	PGPPackMsg		pkt;
	PGPInt32		length = 0;
	PGPInt32		currentSize = 0;
	const PGPInt32		headerSize = sizeof(PGPInt32) * 3;
	PGPContextRef		context = kInvalidPGPContextRef;
	char			*outbuf = NULL;
	int			outbuflen;
	char			*bufcopy = NULL;
	int			uid, gid;
	struct ucred		ucred;
	socklen_t		len;

	if(PGPNewContext(kPGPsdkAPIVersion, &context) != kPGPError_NoErr)
		goto out;

	len = sizeof(struct ucred);
	n = getsockopt(sd, SOL_SOCKET, SO_PEERCRED, &ucred, &len);
	if (n != 0) {
		perror("getsockopt(SO_PEERCRED)");
		goto out;
	}
		
	uid = ucred.uid;
	gid = ucred.gid;

	buf = (char *)PGPNewSecureData(PGPPeekContextMemoryMgr(context), headerSize, 0);
	if(buf == NULL)
		goto out;
	currentSize = headerSize;

	for(;;) {
		/*	Read header	*/
		n = read(sd, buf, headerSize);
		if (n == 0 || n == -1)
			goto out;
		pkt.ptr = 0;
		pkt.length = 0;
		pkt.base = buf;

		/*	skip first two ints in header	*/
		unpack_int32(&pkt);
		unpack_int32(&pkt);
		length = unpack_int32(&pkt);

		if(length != 0)
		{
			if(length  > currentSize)
			{
				currentSize = length;
				if(PGPReallocData(PGPPeekContextMemoryMgr(context), (void **)&buf, currentSize, 0) != kPGPError_NoErr)
					goto out;
			}
		}
		else
			goto out;
		if(length > headerSize)
		{
			next = buf;
			next += headerSize;
			n += read(sd, next, length - headerSize);

			if(n == 0 || n == -1)
				goto out;
			/*	Make sure that we've read all the data	*/
			while(n != length)
			{
				/*	Read more data	*/
				next = buf + n;
				n += read(sd, next, length - n);
			}
		}

		PGPMutexLock(&sRPCMutex);

		if(setegid(gid) == -1)
		{
			PGPMutexUnlock(&sRPCMutex);
			goto out;
		}
		if(seteuid(uid) == -1)
		{
			PGPMutexUnlock(&sRPCMutex);
			goto out;
		}

		rcv_generic(buf, n, (PGPByte **)&outbuf, &outbuflen);

		if(outbuflen < currentSize)
		{
			memcpy(buf, outbuf, outbuflen);
		}
		else
		{
			currentSize = outbuflen;
			if(PGPReallocData(PGPPeekContextMemoryMgr(context), (void **)&buf, currentSize, 0) != kPGPError_NoErr)
			{
				PGPMutexUnlock(&sRPCMutex);	
				goto out;
			}
			memcpy(buf, outbuf, outbuflen);
		}
		if (!PGPIsInitRPCBuf(outbuf))
			PGPFreeData(outbuf);

		if(seteuid(rootUserID) == -1)
		{
			PGPMutexUnlock(&sRPCMutex);
			goto out;
		}
		if(setegid(rootGrpID) == -1)
		{
			PGPMutexUnlock(&sRPCMutex);
			goto out;
		}

		PGPMutexUnlock(&sRPCMutex);

		n = write(sd, buf, outbuflen);
		if (n != outbuflen)
		{
			goto out;
		}
	}
out:
	if(buf != NULL)
		PGPFreeData(buf);
	PGPMutexLock(&sRPCMutex);
	setegid(gid);
	seteuid(uid);
	if(context != kInvalidPGPContextRef)
		PGPFreeContext(context);
	seteuid(rootUserID);
	setegid(rootGrpID);
	PGPMutexUnlock(&sRPCMutex);
	close(sd);
}

void
pgpRPCGetUnixClientAuth(pgpRPCconnection *conn_ref)
{
	char name[20];
	PGPByte *cp;

	sprintf(name, "%d", geteuid());
	cp = PGPNewData(PGPGetDefaultMemoryMgr(), strlen(name)+1,0);
	pgpCopyMemory(name, cp, strlen(name)+1);
	conn_ref->UserName = cp;
	conn_ref->uid = 0;
	conn_ref->gid = 0;
	conn_ref->pid = 0;
}

PGPBoolean
pgpRPCVerifyUnixClientAuth(pgpRPCconnection *conn_ref)
{
	return TRUE;
}

